IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_Productos_Cobros') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_Productos_Cobros
END
GO

CREATE PROCEDURE [dbo].[CP_Productos_Cobros](
     @pUsuario INT
   , @pEquate  SMALLINT
   , @pFechaDesde DATETIME
   , @pFechaHasta DATETIME
   , @GenerarLiquidacion TINYINT
   , @Id_Periodo_Caja INT
   , @Detallar_FPago SMALLINT
   , @Tipo_Cob CHAR(1)    -- vacio = todos  M = Manual L=Lote
   )
AS

  CREATE TABLE #Trans (Id_Trans INT)

  IF @pEquate = 0
     RETURN

  DECLARE @Id_Producto Varchar(14)
  ,@Id_Proveedor Int
  ,@Razon_Social VarChar(100)
  ,@Cuit Varchar(13)
  ,@Id_Iva Char(3)
  ,@Id_Alias_Cta_Cont Int
  ,@Id_Cta_Contable_H Int
  ,@Porc_Comision_Prov Decimal(7,2) 
  ,@Importe Decimal(12,2) 
  ,@IMPORTE_CREDITO Decimal(12,2) 
  ,@ID_TIPO_CBTE CHAR(4) 
  ,@FECHA DATETIME
  ,@Imp_prod_siva  Decimal(12,2) 
  ,@TRANS INT
  ,@Id_Cliente_Externo VARCHAR(14)
  ,@Id_Cta_Banco INT
  ,@Id_Cliente INT
  ,@EXISTE_TAG INT

  SET @FECHA = (SELECT CAST(GETDATE() AS DATE))

  DECLARE @Sql		    VARCHAR(MAX)
  DECLARE @SqlSaldo	    VARCHAR(MAX)
  DECLARE @SqlSelect	VARCHAR(MAX)
  DECLARE @SqlInto	    VARCHAR(MAX)
  DECLARE @SqlFrom	    VARCHAR(MAX)
  DECLARE @SqlWhere  	VARCHAR(MAX)
  DECLARE @SqlGroup	    VARCHAR(MAX)

  SET @EXISTE_TAG = 0
  SET @EXISTE_TAG = (SELECT COUNT(*) FROM TagFilePos_ TAG WHERE TAG.TBL = @pEquate AND TAG.USR = @pUsuario)

  SELECT (i.Imp_Gravado * F.Cotizacion) as Imp_Gravado_Item													--1
		,(i.Imp_Final * F.Cotizacion) as Imp_Final_Item														--2
		,f.Id_trans as Id_Trans_Fac																			--3
		,(f.Imp_Gravado + f.Imp_Gravado2 + f.Imp_Gravado3 + f.Imp_Exento) * F.Cotizacion as Importe_Fac		--4
		,f.Imp_total * F.Cotizacion as Imp_total_Fac														--5
		,r.Id_trans as Id_Trans_Rec																			--6
		,a.Importe  as Importe_Aplicado																		--7
		,i.Fecha_QA																							--8
		,i.Fecha_Venc																						--9
		,i.Id_cliente																						--10
		,C.Nombre_Fantasia																					--11
		,C.Id_Cliente_Externo																				--12
		,C.Razon_Social																						--13
		,C.Id_Tipo_Cli																						--14
		,dbo.CF_Cbte_Descrip(f.id_trans) as Desc_Factura													--15
		,F.Fecha																							--16
		,dbo.CF_Cbte_Descrip(R.id_trans) as Desc_Recibo														--17
		,R.Fecha as Fecha_Rec																				--18
		,R.Imp_Total as Imp_Total_Rec																		--19
		,R.Id_Estado_Cbte																					--20
		,R.Cotizacion as Cotizacion_Rec																		--21
		,F.Cotizacion as Cotizacion_Fac																		--22
		,F.Porc_Bonificacion																				--23
		,F.Id_Cobrador																						--24
		,I.Id_Producto																						--25
		,P.Descripcion_Detallada																			--26
		,P.Id_Familia																						--27
		,FP.Descripcion as Descripcion_Familia																--28
		,(a.Importe / f.Imp_total) * 100 as porc_aplicado													--29
		,(i.Imp_Final *  F.Cotizacion )  * ( a.Importe / f.Imp_total) * (1 -(F.Porc_Bonificacion / 100)) as imp_prod_civa --30
		,(i.Imp_Gravado * F.Cotizacion ) * ( a.Importe / f.Imp_total) * (1 -(F.Porc_Bonificacion / 100)) as imp_prod_siva --31
		,V.DESCRIPCION AS NOMBRE_COBRADOR																	--32
		,[dbo].[SF_Cli_Categ_Mes](i.Id_cliente, isnull(i.Fecha_QA,F.Fecha)) as Tipo_Cli						--33
		,CT.DESCRIPCION																						--34
		,isnull(c.id_cliente_ref,0) as id_cliente_ref														--35
		,cast(0 as decimal(12,2)) AS EFECTIVO																--36
		,cast(0 as decimal(12,2)) AS TARJETA																--37
		,cast(0 as decimal(12,2)) AS CHEQ_TER																--38
		,cast(0 as decimal(12,2)) AS CHEQ_PROP																--39
		,cast(0 as decimal(12,2)) AS DEBITO																	--40
		,cast(0 as decimal(12,2)) AS FINANC																	--41
		,cast(0 as decimal(12,2)) AS OTROS																	--42
		,cast(0 as decimal(12,2)) AS Total_Pagos															--43
		,cast(0 as decimal(12,2)) AS Dif																	--44
		,i.Item as Item_Fac																					--45
		,cast(0 as decimal(12,5)) AS Coef_Pago																--46 
		,ISNULL(C.Id_Cond_Pago, 0) AS Id_Cond_Pago															--47 14/01/2020 Agregado Ticket 18.924
		,ISNULL(CCP.Descripcion, '') AS Cond_Pago															--48 14/01/2020 Agregado Ticket 18.924
		,f.Imp_Percep AS Imp_Total_Percep_Reten_Fac															--49 14/01/2020 Agregado Ticket 18.924
		,r.Imp_Percep AS Imp_Total_Percep_Reten_Rec															--50 14/01/2020 Agregado Ticket 18.924
		,CLFC.Nombre_Fantasia		AS FC_CL_Nombre_Fantasia												--51 27/01/2021
		,CLFC.Id_Cliente_Externo	AS FC_CL_Id_Cliente_Externo												--52 27/01/2021
		,CLFC.Razon_Social			AS FC_CL_Razon_Social													--53 27/01/2021
		,CLFC.Id_Tipo_Cli			AS FC_CL_Id_Tipo_Cli													--54 27/01/2021
		,C.Id_Cobrador				AS CL_Id_Cobrador														--55 04/02/2021
		,CP.Id_Caja					AS Id_Caja																--56 04/02/2021
		,I.Bonif					AS Porc_Bonif_Item														--57 13/04/2021 Agregado Ticket 22.253
		,((100 * I.Imp_Final) / (100-I.Bonif)) AS Imp_Final_Item_Sin_Desc									--58 13/04/2021 Agregado Ticket 22.253
		,(((100 * I.Imp_Final) / (100-I.Bonif)) * (I.Bonif / 100)) AS Imp_Bonif_Item						--59 13/04/2021 Agregado Ticket 22.253
   INTO #Reporte
   FROM cbtes_items i,cbtes f,cbtes_aplica a,cbtes r, cbtes_tipos tr, Cbtes_Tipos TF, Clientes C,TagFilePos_ TAG, Productos P,Prod_Familias FP, Vendedores V, Clientes_Tipos CT, Cbtes_Cond_Pago CCP, Clientes CLFC, Cajas_Mov CM, Cajas_Periodos CP
   WHERE 1=0

   SET @SqlSelect =  ' SELECT (i.Imp_Gravado * F.Cotizacion) as Imp_Gravado_Item     --1
							  ,(i.Imp_Final * F.Cotizacion) as Imp_Final_Item               --2
							  ,f.Id_trans as Id_Trans_Fac                                   --3
							  ,(f.Imp_Gravado + f.Imp_Gravado2 + f.Imp_Gravado3 + f.Imp_Exento) * F.Cotizacion as Importe_Fac   --4
							  ,f.Imp_total * F.Cotizacion as Imp_total_Fac   --5
							  ,r.Id_trans as Id_Trans_Rec                    --6
							  ,a.Importe  as Importe_Aplicado                --7
							  ,i.Fecha_QA                                    --8
							  ,i.Fecha_Venc                                  --9
							  ,CASE
								WHEN i.Id_Cliente IS NULL THEN F.Id_Cliente  --10
								WHEN i.Id_Cliente = 0 THEN F.Id_Cliente
								ELSE i.Id_Cliente
								END AS Id_Cliente
							  ,C.Nombre_Fantasia                             --11
							  ,C.Id_Cliente_Externo                          --12
							  ,C.Razon_Social                                --13
							  ,C.Id_Tipo_Cli                                 --14
							  ,dbo.CF_Cbte_Descrip(f.id_trans) as Desc_Factura    --15
							  ,F.Fecha                                            --16
							  ,dbo.CF_Cbte_Descrip(R.id_trans) as Desc_Recibo     --17
							  ,R.Fecha as Fecha_Rec								  --18
							  ,R.Imp_Total as Imp_Total_Rec					      --19
							  ,R.Id_Estado_Cbte									  --20
							  ,R.Cotizacion as Cotizacion_Rec                     --21
							  ,F.Cotizacion as Cotizacion_Fac                     --22
							  ,F.Porc_Bonificacion								  --23
							  ,F.Id_Cobrador								      --24
							  ,I.Id_Producto									  --25
							  ,P.Descripcion_Detallada						      --26
							  ,P.Id_Familia										  --27
							  ,FP.Descripcion as Descripcion_Familia              --28
							  ,(R.Imp_Total / (select sum(z.Importe) from cbtes_aplica z where z.id_trans_d = r.id_trans  and z.importe > 1))*100 as porc_aplicado   --29
							  ,(i.Imp_Final *  F.Cotizacion )  * ( a.Importe / f.Imp_total) * (R.Imp_Total / (select sum(z.Importe) from cbtes_aplica z where z.id_trans_d = r.id_trans  and z.importe > 1)) * (1 -(F.Porc_Bonificacion / 100)) as imp_prod_civa --30
							  ,(i.Imp_Gravado * F.Cotizacion ) * ( a.Importe / f.Imp_total) * (R.Imp_Total / (select sum(z.Importe) from cbtes_aplica z where z.id_trans_d = r.id_trans  and z.importe > 1)) * (1 -(F.Porc_Bonificacion / 100)) as imp_prod_siva --31
							  ,V.DESCRIPCION AS NOMBRE_COBRADOR                                               --32
							  ,[dbo].[SF_Cli_Categ_Mes](i.Id_cliente, isnull(i.Fecha_QA,F.Fecha)) as Tipo_Cli --33
							  ,CT.DESCRIPCION                                                                 --34
							  ,isnull(c.id_cliente_ref,0) as id_cliente_ref                                   --35
							  ,cast(0 as decimal(12,2)) AS EFECTIVO                                           --36
							  ,cast(0 as decimal(12,2)) AS TARJETA                                            --37
							  ,cast(0 as decimal(12,2)) AS CHEQ_TER                                           --38
							  ,cast(0 as decimal(12,2)) AS CHEQ_PROP                                          --39
							  ,cast(0 as decimal(12,2)) AS DEBITO                                             --40
							  ,cast(0 as decimal(12,2)) AS FINANC                                             --41
							  ,cast(0 as decimal(12,2)) AS OTROS                                              --42
							  ,cast(0 as decimal(12,2)) AS Total_Pagos                                        --43
							  ,cast(0 as decimal(12,2)) AS Dif                                                --44
							  ,i.Item as Item_Fac															  --45
							  ,cast(0 as decimal(12,5)) AS Coef_Pago										  --46  
							  ,ISNULL(C.Id_Cond_Pago, 0) AS Id_Cond_Pago									--47 14/01/2020 Agregado Ticket 18.924
							  ,ISNULL(CCP.Descripcion, '''') AS Cond_Pago									--48 14/01/2020 Agregado Ticket 18.924
							  ,f.Imp_Percep AS Imp_Total_Percep_Reten_Fac									--49 14/01/2020 Agregado Ticket 18.924
							  ,r.Imp_Percep AS Imp_Total_Percep_Reten_Rec									--50 14/01/2020 Agregado Ticket 18.924
							  ,CLFC.Nombre_Fantasia		AS FC_CL_Nombre_Fantasia							--51 27/01/2021
							  ,CLFC.Id_Cliente_Externo	AS FC_CL_Id_Cliente_Externo							--52 27/01/2021
							  ,CLFC.Razon_Social		AS FC_CL_Razon_Social								--53 27/01/2021
							  ,CLFC.Id_Tipo_Cli			AS FC_CL_Id_Tipo_Cli								--54 27/01/2021
							  ,C.Id_Cobrador			AS CL_Id_Cobrador								    --55 04/02/2021
							  ,CP.Id_Caja				AS Id_Caja											--56 04/02/2021
							  ,I.Bonif					AS Porc_Bonif_Item									--57 13/04/2021 Agregado Ticket 22.253
							  ,CASE ISNULL(I.Imp_Final,0) WHEN 0 THEN 0
							    ELSE  ((I.Imp_Final) / (1-(I.Bonif/100)) ) END AS Imp_Final_Item_Sin_Desc	--58 13/04/2021 Agregado Ticket 22.253
							
							  ,CASE ISNULL(I.Imp_Final,0) WHEN 0 THEN 0
							    ELSE  ((I.Imp_Final) / (1-(I.Bonif/100)) ) - I.Imp_Final END AS Imp_Bonif_Item	--59 13/04/2021 Agregado Ticket 22.253
'
/*
							  ,((100 * I.Imp_Final) / (100-I.Bonif)) AS Imp_Final_Item_Sin_Desc				--58 13/04/2021 Agregado Ticket 22.253
							  ,(((100 * I.Imp_Final) / (100-I.Bonif)) * (I.Bonif / 100)) AS Imp_Bonif_Item	--59 13/04/2021 Agregado Ticket 22.253
							  '
*/
  SET @SqlInto = ' ' 

  SET @SqlWhere = 'WHERE r.id_tipo_cbte = tr.id_tipo_cbte
						    AND tr.compromete_recibos in (1,-1)
							AND r.id_cliente = c.id_Cliente
							AND ISNULL(F.Id_Cliente, 0) = CLFC.Id_Cliente
							AND a.id_trans_d = r.id_trans 
							AND f.id_trans = a.id_trans 
							AND f.id_estado_cbte in (1,2,4) 
							AND r.id_estado_cbte in (2,4)
							AND i.id_trans = f.id_trans 
							AND f.id_tipo_cbte = TF.id_tipo_cbte 
							AND I.Id_Producto = P.Id_Producto
							AND ISNULL(P.Id_Familia,0) = ISNULL(FP.Id_Familia,0)
							AND ISNULL(F.Id_Cond_Pago, 0) = ISNULL(CCP.Id_Cond_Pago, 0)
							AND CM.Id_Trans = R.Id_Trans
							AND CM.Id_Periodo_Caja = CP.Id_Periodo_Caja
							AND r.Fecha >= ''' + CONVERT(VARCHAR(8),@pFechaDesde   ,112) + '''
							AND r.Fecha <  ''' + CONVERT(VARCHAR(8),@pFechaHasta+1 ,112) + '''
							AND F.Imp_total <> 0
							AND R.Imp_Total <> 0
							AND TF.Compromete_Factura = 1 
							AND ISNULL(F.Id_Cobrador,'''') = ISNULL(V.Id_Vendedor,'''')
 							AND ISNULL(CT.ID_TIPO_CLI,0) = ISNULL([dbo].[SF_Cli_Categ_Mes](i.Id_cliente, isnull(i.Fecha_QA,F.Fecha)),0)'

  IF UPPER(@Tipo_Cob) = 'M'
	 SET @SqlWhere = LTRIM(RTRIM(@SqlWhere)) + '	AND ISNULL(R.Lote,'''') = '''''

  IF ISNULL(@Tipo_Cob,'') = 'L'
	 SET @SqlWhere = LTRIM(RTRIM(@SqlWhere)) + '	AND ISNULL(R.Lote,'''') != '''''


  IF @EXISTE_TAG > 0
  BEGIN
	  SET @SqlFrom = 'FROM cbtes_items i,cbtes f,cbtes_aplica a,cbtes r, cbtes_tipos tr, Cbtes_Tipos TF, Clientes C,TagFilePos_ TAG, Productos P,Prod_Familias FP, Vendedores V, Clientes_Tipos CT, Clientes CLFC, Cbtes_Cond_Pago CCP, Cajas_Mov CM, Cajas_Periodos CP'
      SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND (i.id_producto = TAG.POS 
							      AND TAG.TBL = ' + CAST(@pEquate  AS VARCHAR(10))  + '
								  AND TAG.USR = ' + CAST(@pUsuario AS VARCHAR(10)) + '
								 ) ' 
  END
  ELSE
  BEGIN
	  SET @SqlFrom = 'FROM cbtes_items i,cbtes f,cbtes_aplica a,cbtes r, cbtes_tipos tr, Cbtes_Tipos TF, Clientes C, Productos P,Prod_Familias FP, Vendedores V, Clientes_Tipos CT, Clientes CLFC, Cbtes_Cond_Pago CCP, Cajas_Mov CM, Cajas_Periodos CP'
  END
  

  SET @Sql = @SqlSelect + ' ' + @SqlInto +' '+ @SqlFrom + ' ' + @SqlWhere 

 EXEC('INSERT INTO #Reporte ' + @sql)
							 

  IF @Detallar_FPago = 1
      BEGIN 
		  Select Distinct(Id_Trans_Rec) Into #Cbtes_a_Procesar From #Reporte

		  SELECT VM.Id_Trans, MAX(VM.Renglon_Nro) AS Renglon_Nro
		  INTO #Max_Renglon 
		  FROM Valores_Mov VM , #Cbtes_a_Procesar C WHERE VM.Id_Trans = C.Id_Trans_Rec
		  GROUP BY VM.Id_Trans

		  Select VM.Id_Trans as Id_Trans_Rec,V.Id_Tipo_Val,Sum(V.Importe) AS IMPORTE 
		  INTO #SUMA_PAGOS 
		  from #Cbtes_a_Procesar C, Valores_Mov VM, Valores V, #Max_Renglon MR
		  WHERE C.Id_Trans_Rec = VM.Id_Trans AND V.Id_Valor = VM.ID_VALOR AND VM.Id_Trans = MR.Id_Trans AND VM.Renglon_Nro = MR.Renglon_Nro
		  GROUP BY VM.Id_Trans,V.Id_Tipo_Val

		  CREATE INDEX INDEX_SUMA_PAGOS ON #SUMA_PAGOS (Id_Trans_Rec,Id_Tipo_Val)

		  SELECT D.Id_Trans_Rec,R.Id_Trans_Fac,R.Item_Fac,
			 (SELECT ISNULL(SUM(IMPORTE),0) FROM #SUMA_PAGOS WHERE Id_Trans_Rec = D.Id_Trans_Rec AND D.ID_TIPO_VAL = 'EFE') * (Imp_prod_civa/Imp_Total_Rec) AS EFECTIVO,
			 (SELECT ISNULL(SUM(IMPORTE),0) FROM #SUMA_PAGOS WHERE Id_Trans_Rec = D.Id_Trans_Rec AND D.ID_TIPO_VAL = 'TAR') * (Imp_prod_civa/Imp_Total_Rec) AS TARJETA,
			 (SELECT ISNULL(SUM(IMPORTE),0) FROM #SUMA_PAGOS WHERE Id_Trans_Rec = D.Id_Trans_Rec AND D.ID_TIPO_VAL = 'CH3') * (Imp_prod_civa/Imp_Total_Rec) AS CHEQ_TER,
			 (SELECT ISNULL(SUM(IMPORTE),0) FROM #SUMA_PAGOS WHERE Id_Trans_Rec = D.Id_Trans_Rec AND D.ID_TIPO_VAL = 'CHP') * (Imp_prod_civa/Imp_Total_Rec) AS CHEQ_PROP,
			 (SELECT ISNULL(SUM(IMPORTE),0) FROM #SUMA_PAGOS WHERE Id_Trans_Rec = D.Id_Trans_Rec AND D.ID_TIPO_VAL = 'DB') * (Imp_prod_civa/Imp_Total_Rec) AS DEBITO,
			 (SELECT ISNULL(SUM(IMPORTE),0) FROM #SUMA_PAGOS WHERE Id_Trans_Rec = D.Id_Trans_Rec AND D.ID_TIPO_VAL = 'FIN') * (Imp_prod_civa/Imp_Total_Rec) AS FINANC,
			 (SELECT ISNULL(SUM(IMPORTE),0) FROM #SUMA_PAGOS WHERE Id_Trans_Rec = D.Id_Trans_Rec AND D.ID_TIPO_VAL NOT IN ('EFE','TAR','CH3','CHP','DB','FIN') ) * (Imp_prod_civa/Imp_Total_Rec) AS OTROS    
			 ,Imp_prod_civa/Imp_Total_Rec as Coef_Pago
			 INTO #DETALLE_PAGOS
			 FROM #SUMA_PAGOS D, #Reporte R 
			 WHERE D.Id_Trans_Rec = R.Id_Trans_Rec  

		UPDATE  #Reporte SET EFECTIVO = D.EFECTIVO, TARJETA = D.TARJETA, CHEQ_TER = D.CHEQ_TER, CHEQ_PROP = D.CHEQ_PROP, DEBITO = D.DEBITO, OTROS = D.OTROS
		         ,Total_Pagos = D.EFECTIVO + D.TARJETA + D.CHEQ_TER + D.CHEQ_PROP + D.DEBITO + D.OTROS
				 ,Dif = D.EFECTIVO + D.TARJETA + D.CHEQ_TER + D.CHEQ_PROP + D.DEBITO + D.OTROS - imp_prod_civa
				 ,Coef_Pago = D.Coef_Pago
				FROM #DETALLE_PAGOS D, #Reporte R 
				 WHERE D.Id_Trans_Rec = R.Id_Trans_Rec 
				   AND D.Id_Trans_Fac = R.Id_Trans_Fac
				   AND D.Item_Fac = R.Item_Fac
				  
	    DROP TABLE  #DETALLE_PAGOS
		DROP TABLE  #SUMA_PAGOS
		DROP TABLE  #Cbtes_a_Procesar
     END

 -- SELECT * FROM #Reporte
 

  IF @GenerarLiquidacion = 1
	  BEGIN
	  DECLARE CUR_GENERAR CURSOR FOR

	  SELECT R.Id_Producto,P.Id_Proveedor,O.Razon_Social,O.Cuit,O.Id_Iva,P.Id_Alias_Cta_Cont,O.Id_Cta_Contable_H,P.Porc_Comision_Prov,P.Id_Cta_Banco,SUM(R.imp_prod_siva) 
              FROM #Reporte R, Productos P, Proveedores O		
			  Where R.Id_Producto = P.Id_Producto And P.Id_Proveedor = O.Id_Proveedor
			  And (Isnull(P.Id_Proveedor,0) <> 0
			  Or Isnull(P.Id_Cta_Banco,0) <> 0)
			  Group by R.Id_Producto,P.Id_Proveedor,O.Razon_Social,O.Cuit,O.Id_Iva,P.Id_Alias_Cta_Cont,O.Id_Cta_Contable_H,P.Porc_Comision_Prov,P.Id_Cta_Banco

	  OPEN CUR_GENERAR
	  FETCH NEXT FROM CUR_GENERAR INTO  @Id_Producto,@Id_Proveedor,@Razon_Social,@Cuit,@Id_Iva,@Id_Alias_Cta_Cont,@Id_Cta_Contable_H,@Porc_Comision_Prov,@Id_Cta_Banco,@Importe
	  WHILE @@FETCH_STATUS = 0
	      BEGIN
		         DELETE #Trans
                 IF @Id_Proveedor > 0
				    BEGIN
						 SET @ID_TIPO_CBTE =  (select Valor_String from xParametros where setDatos= 1 and idParametro ='T_Cbte_Deb_Liq_Ter')

						 INSERT INTO #Trans
							 EXEC dbo.CP_Cbtes_Cpra_Generar  @Id_Proveedor,@Razon_Social,@Importe,1,@FECHA,@ID_TIPO_CBTE,'',1,10,100,@trans OUTPUT
                    END
				   ELSE
				    BEGIN
						 SET @ID_TIPO_CBTE =  (select Valor_String from xParametros where setDatos= 1 and idParametro ='T_Cbte_Dep_Cta_Prom')

						 INSERT INTO #Trans
							 EXEC dbo.CP_Cbtes_Deposito_Generar  @Id_Cta_Banco,@Razon_Social,@Importe,1,@FECHA,@ID_TIPO_CBTE,'',2,10,100,@Id_Periodo_Caja,@trans OUTPUT

						 SET @ID_TIPO_CBTE =  (select Valor_String from xParametros where setDatos= 1 and idParametro ='T_Cbte_OP_Prom')

						 EXEC dbo.CP_Cbtes_OP_Varia_Generar  @Id_Cta_Banco,@Razon_Social,@Importe,1,@FECHA,@ID_TIPO_CBTE,'',2,10,100,@Id_Periodo_Caja,@trans OUTPUT

						 SET @trans = 0
					END

				 If @trans > 0
				    Begin
						 DECLARE CUR_GENERAR_ITEMS CURSOR FOR

						 SELECT R.Razon_Social,R.Imp_prod_siva,R.Id_Cliente_Externo 
								  FROM #Reporte R	
								  Where R.Id_Producto = @Id_Producto

						 OPEN CUR_GENERAR_ITEMS
						 FETCH NEXT FROM CUR_GENERAR_ITEMS INTO  @Razon_Social,@Imp_prod_siva,@Id_Cliente_Externo
						 WHILE @@FETCH_STATUS = 0
						 BEGIN
				              SET @Razon_Social = LTRIM(RTRIM(@Id_Cliente_Externo)) +' '+ LTRIM(RTRIM(@Razon_Social))
							  SET @Id_Cliente = 0
							  SET @Id_Cta_Banco = 0
							  EXEC dbo.SP_CbteItem_Agr   @Id_Producto,@trans,1,@Imp_prod_siva,@fecha,'',@Razon_Social,@ID_Cliente,@Id_Cta_Banco
                     
							  FETCH NEXT FROM CUR_GENERAR_ITEMS INTO  @Razon_Social,@Imp_prod_siva,@Id_Cliente_Externo 	
						 END  
						 CLOSE CUR_GENERAR_ITEMS
					     DEALLOCATE CUR_GENERAR_ITEMS
                 END
			 	 IF @Porc_Comision_Prov > 0
				    BEGIN
					    SET @Razon_Social = (SELECT RAZON_SOCIAL FROM PROVEEDORES WHERE ID_PROVEEDOR = @Id_Proveedor)
				        SET @ID_TIPO_CBTE =  (select Valor_String from xParametros where setDatos= 1 and idParametro ='T_Cbte_Cred_Liq_Ter')
				        SET @IMPORTE_CREDITO = (@Importe * (@Porc_Comision_Prov/100)) * -1
			        	EXEC dbo.CP_Cbtes_Cpra_Generar @Id_Proveedor,@Razon_Social,@IMPORTE_CREDITO,1,@FECHA,@ID_TIPO_CBTE,'PRUEBA',1,10,100,@Trans OUTPUT
		 		    END

	      FETCH NEXT FROM CUR_GENERAR INTO  @Id_Producto,@Id_Proveedor,@Razon_Social,@Cuit,@Id_Iva,@Id_Alias_Cta_Cont,@Id_Cta_Contable_H,@Porc_Comision_Prov,@Id_Cta_Banco,@Importe
	 END  
	 CLOSE CUR_GENERAR
	 DEALLOCATE CUR_GENERAR 
  
  END

  insert into #Reporte
                        SELECT 0 as Imp_Gravado_Item                         --1
							  ,0 as Imp_Final_Item                           --2
							  ,0 as Id_Trans_Fac                             --3
							  ,0 as Importe_Fac                              --4
							  ,0 as Imp_total_Fac                            --5
							  ,r.Id_trans as Id_Trans_Rec                    --6
							  ,r.imp_total as Importe_Aplicado                  --7
							  ,r.Fecha  as Fecha_QA                          --8
							  ,r.Fecha  as Fecha_Venc                        --9
							  ,c.Id_cliente                                  --10
			  			      ,C.Nombre_Fantasia                             --11
							  ,C.Id_Cliente_Externo                          --12
							  ,C.Razon_Social                                --13
							  ,C.Id_Tipo_Cli                                 --14
							  ,'' as Desc_Factura                            --15
							  ,r.Fecha                                            --16
							  ,dbo.CF_Cbte_Descrip(R.id_trans) as Desc_Recibo     --17
							  ,R.Fecha as Fecha_Rec								  --18
							  ,R.Imp_Total as Imp_Total_Rec					      --19
							  ,R.Id_Estado_Cbte									  --20
							  ,R.Cotizacion as Cotizacion_Rec                     --21
							  ,0 as Cotizacion_Fac                                --22
							  ,0 as Porc_Bonificacion							  --23
							  ,r.Id_Cobrador								      --24
							  ,'' as Id_Producto								  --25
							  ,'PAGO A CUENTA' AS descripcion_Detallada		      --26
							  ,0 as Id_Familia									  --27
							  ,'' as Descripcion_Familia                          --28
							  ,0 as porc_aplicado                                 --29
							  ,r.saldo  as imp_prod_civa                          --30
							  ,r.saldo  as imp_prod_siva                          --31
							  ,V.DESCRIPCION AS NOMBRE_COBRADOR                   --32
							  ,ISNULL([dbo].[SF_Cli_Categ_Mes](r.Id_cliente, r.Fecha),0) as Tipo_Cli --33
							  ,CT.DESCRIPCION                                   --34
							  ,isnull(c.id_cliente_ref,0) as id_cliente_ref                                 --35
							  ,cast(0 as decimal(12,2)) AS EFECTIVO                                         --36
							  ,cast(0 as decimal(12,2)) AS TARJETA                                          --37
							  ,cast(0 as decimal(12,2)) AS CHEQ_TER                                         --38
							  ,cast(0 as decimal(12,2)) AS CHEQ_PROP                                        --39
							  ,cast(0 as decimal(12,2)) AS DEBITO                                           --40
							  ,cast(0 as decimal(12,2)) AS FINANC                                           --41
							  ,cast(0 as decimal(12,2)) AS OTROS                                            --42
							  ,cast(0 as decimal(12,2)) AS Total_Pagos                                      --43
							  ,cast(0 as decimal(12,2)) AS Dif                                              --44
							  ,1 as Item_Fac															    --45
							  ,cast(0 as decimal(12,5)) AS Coef_Pago										--46  
							  ,ISNULL(C.Id_Cond_Pago, 0) AS Id_Cond_Pago									--47 14/01/2020 Agregado Ticket 18.924
							  ,ISNULL(CCP.Descripcion, '''') AS Cond_Pago									--48 14/01/2020 Agregado Ticket 18.924
							  ,0 AS Imp_Total_Percep_Reten_Fac												--49 14/01/2020 Agregado Ticket 18.924
							  ,r.Imp_Percep AS Imp_Total_Percep_Reten_Rec									--50 14/01/2020 Agregado Ticket 18.924
							,''							AS FC_CL_Nombre_Fantasia							--51 27/01/2021
							,''							AS FC_CL_Id_Cliente_Externo							--52 27/01/2021
							,''							AS FC_CL_Razon_Social								--53 27/01/2021
							,0							AS FC_CL_Id_Tipo_Cli								--54 27/01/2021
							,C.Id_Cobrador				AS CL_Id_Cobrador									--55 04/02/2021
							,CP.Id_Caja					AS Id_Caja											--56 04/02/2021
							,0							AS Porc_Bonif_Item									--57 13/04/2021 Agregado Ticket 22.253
							,0							AS Imp_Final_Item_Sin_Desc							--58 13/04/2021 Agregado Ticket 22.253
							,0							AS Imp_Bonif_Item									--59 13/04/2021 Agregado Ticket 22.253
   FROM cbtes r, cbtes_tipos tr,  Clientes C, Vendedores V, Clientes_Tipos CT, Cbtes_Cond_Pago CCP, Cajas_Mov CM, Cajas_Periodos CP
   WHERE r.id_tipo_cbte = tr.id_tipo_cbte 
   and tr.Compromete_Recibos in (1,-1)
   AND C.ID_CLIENTE = R.ID_CLIENTE
   AND R.ID_ESTADO_CBTE IN (1,4,2)
  -- AND R.SALDO <> 0
   AND r.Id_Cobrador = v.id_vendedor
   AND CM.Id_Trans = R.Id_Trans
   AND CM.Id_Periodo_Caja = CP.Id_Periodo_Caja
   AND ISNULL(CT.ID_TIPO_CLI,0) = ISNULL([dbo].[SF_Cli_Categ_Mes](r.Id_cliente, r.Fecha),0)
   AND R.Fecha >= @pFechaDesde
   AND r.Fecha <  @pFechaHasta+1 
   AND ISNULL(C.Id_Cond_Pago, 0) = ISNULL(CCP.Id_Cond_Pago, 0)
   and r.id_Trans not in (select id_Trans from cbtes_items)

-------------------------------------------------------------------------------------------

   SET @SqlSelect =  ' SELECT (i.Imp_Gravado * F.Cotizacion) * (1 -(F.Porc_Bonificacion / 100)) * (TF.Compromete_Factura) as Imp_Gravado_Item            --1
							  ,(i.Imp_Final * F.Cotizacion) * (1 -(F.Porc_Bonificacion / 100))  * (TF.Compromete_Factura) as Imp_Final_Item               --2
							  ,f.Id_trans as Id_Trans_Fac                                   --3
							  ,(f.Imp_Gravado + f.Imp_Gravado2 + f.Imp_Gravado3 + f.Imp_Exento) * F.Cotizacion  * (TF.Compromete_Factura) as Importe_Fac --4
							  ,f.Imp_total * F.Cotizacion  * (TF.Compromete_Factura) as Imp_total_Fac   --5
							  ,0 as Id_Trans_Rec                                 --6
							  ,0  as Importe_Aplicado                            --7
							  ,i.Fecha_QA                                    --8
							  ,i.Fecha_Venc                                  --9
							  ,CASE
								WHEN i.Id_Cliente IS NULL THEN F.Id_Cliente  --10
								WHEN i.Id_Cliente = 0 THEN F.Id_Cliente
								ELSE i.Id_Cliente
								END AS Id_Cliente
							  ,C.Nombre_Fantasia                             --11
							  ,C.Id_Cliente_Externo                          --12
							  ,C.Razon_Social                                --13
							  ,C.Id_Tipo_Cli                                 --14
							  ,dbo.CF_Cbte_Descrip(f.id_trans) as Desc_Factura    --15
							  ,F.Fecha                                            --16
							  ,'''' as Desc_Recibo                                  --17
							  ,NULL  as Fecha_Rec							    	  --18
							  ,0 as Imp_Total_Rec					              --19
							  ,f.Id_Estado_Cbte									  --20
							  ,0 as Cotizacion_Rec                                --21
							  ,F.Cotizacion as Cotizacion_Fac                     --22
							  ,F.Porc_Bonificacion								  --23
							  ,F.Id_Cobrador								      --24
							  ,I.Id_Producto									  --25
							  ,P.Descripcion_Detallada						      --26
							  ,P.Id_Familia										  --27
							  ,FP.Descripcion as Descripcion_Familia              --28
							  ,0 as porc_aplicado                               --29
							  ,0 as imp_prod_civa --30
							  ,0 as imp_prod_siva --31
							  ,V.DESCRIPCION AS NOMBRE_COBRADOR                                               --32
							  ,[dbo].[SF_Cli_Categ_Mes](i.Id_cliente, isnull(i.Fecha_QA,F.Fecha)) as Tipo_Cli --33
							  ,CT.DESCRIPCION                                                                 --34
							  ,isnull(c.id_cliente_ref,0) as id_cliente_ref                                   --35
							  ,cast(0 as decimal(12,2)) AS EFECTIVO                                           --36
							  ,cast(0 as decimal(12,2)) AS TARJETA                                            --37
							  ,cast(0 as decimal(12,2)) AS CHEQ_TER                                           --38
							  ,cast(0 as decimal(12,2)) AS CHEQ_PROP                                          --39
							  ,cast(0 as decimal(12,2)) AS DEBITO                                             --40
							  ,cast(0 as decimal(12,2)) AS FINANC                                             --41
							  ,cast(0 as decimal(12,2)) AS OTROS                                              --42
							  ,cast(0 as decimal(12,2)) AS Total_Pagos                                        --43
							  ,cast(0 as decimal(12,2)) AS Dif                                                --44
							  ,i.Item as Item_Fac															  --45
							  ,cast(0 as decimal(12,5)) AS Coef_Pago										  --46 
							  ,0 AS Id_Cond_Pago										                    --47 14/01/2020 Agregado Ticket 18.924
							  ,ISNULL(CCP.Descripcion, '''') AS Cond_Pago									--48 14/01/2020 Agregado Ticket 18.924
							  ,F.IMP_PERCEP AS Imp_Total_Percep_Reten_Fac		  						    --49 14/01/2020 Agregado Ticket 18.924
							  ,0 AS Imp_Total_Percep_Reten_Rec										        --50 14/01/2020 Agregado Ticket 18.924
							  ,CLFC.Nombre_Fantasia		AS FC_CL_Nombre_Fantasia							--51 27/01/2021
							  ,CLFC.Id_Cliente_Externo	AS FC_CL_Id_Cliente_Externo							--52 27/01/2021
							  ,CLFC.Razon_Social		AS FC_CL_Razon_Social								--53 27/01/2021
							  ,CLFC.Id_Tipo_Cli			AS FC_CL_Id_Tipo_Cli								--54 27/01/2021
							  ,C.Id_Cobrador			AS CL_Id_Cobrador									--55 04/02/2021
							  ,0						AS Id_Caja											--56 04/02/2021
							  ,I.Bonif					AS Porc_Bonif_Item									--57 13/04/2021 Agregado Ticket 22.253
							  ,((100 * I.Imp_Final) / (100-I.Bonif)) AS Imp_Final_Item_Sin_Desc				--58 13/04/2021 Agregado Ticket 22.253
							  ,(((100 * I.Imp_Final) / (100-I.Bonif)) * (I.Bonif / 100)) AS Imp_Bonif_Item	--59 13/04/2021 Agregado Ticket 22.253
							  '
  SET @SqlWhere = 'WHERE  
					f.id_cliente = c.id_Cliente
					AND ISNULL(F.Id_Cliente, 0) = CLFC.Id_Cliente
					AND f.id_estado_cbte in (1,2,4) 
					AND i.id_trans = f.id_trans 
					AND f.id_tipo_cbte = TF.id_tipo_cbte 
					AND I.Id_Producto = P.Id_Producto
					AND ISNULL(P.Id_Familia,0) = ISNULL(FP.Id_Familia,0)
					AND f.Fecha >= ''' + CONVERT(VARCHAR(8),@pFechaDesde   ,112) + '''
					AND f.Fecha <  ''' + CONVERT(VARCHAR(8),@pFechaHasta+1 ,112) + '''
					AND F.Imp_total <> 0
					AND ISNULL(F.Id_Cond_Pago, 0) = ISNULL(CCP.Id_Cond_Pago, 0)
					AND TF.Compromete_Factura in (1,-1)
					AND ISNULL(F.Id_Cobrador,'''') = ISNULL(V.Id_Vendedor,'''')
 					AND ISNULL(CT.ID_TIPO_CLI,0) = ISNULL([dbo].[SF_Cli_Categ_Mes](i.Id_cliente, isnull(i.Fecha_QA,F.Fecha)),0)
					AND i.Imp_Gravado <> 0 '

  
  IF @EXISTE_TAG > 0
  BEGIN
	  SET @SqlFrom = 'FROM cbtes_items i,cbtes f, Cbtes_Tipos TF, Clientes C,TagFilePos_ TAG, Productos P,Prod_Familias FP, Vendedores V, Clientes_Tipos CT, Clientes CLFC, Cbtes_Cond_Pago CCP'
      SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND (i.id_producto = TAG.POS 
							      AND TAG.TBL = ' + CAST(@pEquate  AS VARCHAR(10))  + '
								  AND TAG.USR = ' + CAST(@pUsuario AS VARCHAR(10)) + '
								 ) ' 
  END
  ELSE
  BEGIN
	  SET @SqlFrom = 'FROM cbtes_items i,cbtes f, Cbtes_Tipos TF, Clientes C, Productos P,Prod_Familias FP, Vendedores V, Clientes_Tipos CT, Clientes CLFC, Cbtes_Cond_Pago CCP'
  END


  SET @Sql = @SqlSelect + ' ' + @SqlInto +' '+ @SqlFrom + ' ' + @SqlWhere 
  --print @Sql
  EXEC('INSERT INTO #Reporte ' + @sql)

 ---AGREGO TICKET / VENTAS DE CONTADO
 -------------------------------------------------------------------------------------------

   SET @SqlSelect =  ' SELECT (i.Imp_Gravado * F.Cotizacion) * (1 -(F.Porc_Bonificacion / 100)) * (TF.Compromete_Factura) as Imp_Gravado_Item            --1
							  ,(i.Imp_Final * F.Cotizacion) * (1 -(F.Porc_Bonificacion / 100))  * (TF.Compromete_Factura) as Imp_Final_Item               --2
							  ,f.Id_trans as Id_Trans_Fac                                                    --3
							  ,(f.Imp_Gravado + f.Imp_Gravado2 + f.Imp_Gravado3 + f.Imp_Exento) * F.Cotizacion   * (TF.Compromete_Factura) as Importe_Fac --4
							  ,f.Imp_total * F.Cotizacion  * (TF.Compromete_Factura) as Imp_total_Fac         --5
							  ,f.Id_trans  as Id_Trans_Rec                                                    --6
							  ,f.Imp_total * F.Cotizacion  * (TF.Compromete_Factura)  as Importe_Aplicado     --7
							  ,i.Fecha_QA                                    --8
							  ,i.Fecha_Venc                                  --9
							  ,CASE
								WHEN i.Id_Cliente IS NULL THEN F.Id_Cliente  --10
								WHEN i.Id_Cliente = 0 THEN F.Id_Cliente
								ELSE i.Id_Cliente
								END AS Id_Cliente
							  ,C.Nombre_Fantasia                             --11
							  ,C.Id_Cliente_Externo                          --12
							  ,C.Razon_Social                                --13
							  ,C.Id_Tipo_Cli                                 --14
							  ,dbo.CF_Cbte_Descrip(f.id_trans) as Desc_Factura    --15
							  ,F.Fecha                                            --16
							  ,''TICKET CONTADO'' as Desc_Recibo                  --17
							  ,F.Fecha  as Fecha_Rec						      --18
							  ,f.Imp_total * F.Cotizacion  * (TF.Compromete_Factura) as Imp_Total_Rec	 --19
							  ,f.Id_Estado_Cbte									  --20
							  ,F.Cotizacion as Cotizacion_Rec                     --21
							  ,F.Cotizacion as Cotizacion_Fac                     --22
							  ,F.Porc_Bonificacion								  --23
							  ,F.Id_Cobrador								      --24
							  ,I.Id_Producto									  --25
							  ,P.Descripcion_Detallada						      --26
							  ,P.Id_Familia										  --27
							  ,FP.Descripcion as Descripcion_Familia              --28
							  ,100 as porc_aplicado                               --29
							  ,(i.Imp_Final *  F.Cotizacion )  * (1 -(F.Porc_Bonificacion / 100)) as imp_prod_civa --30
							  ,(i.Imp_Gravado * F.Cotizacion ) * (1 -(F.Porc_Bonificacion / 100)) as imp_prod_siva --31
							  ,V.DESCRIPCION AS NOMBRE_COBRADOR                                               --32
							  ,[dbo].[SF_Cli_Categ_Mes](i.Id_cliente, isnull(i.Fecha_QA,F.Fecha)) as Tipo_Cli --33
							  ,CT.DESCRIPCION                                                                 --34
							  ,isnull(c.id_cliente_ref,0) as id_cliente_ref                                   --35
							  ,cast(0 as decimal(12,2)) AS EFECTIVO                                           --36
							  ,cast(0 as decimal(12,2)) AS TARJETA                                            --37
							  ,cast(0 as decimal(12,2)) AS CHEQ_TER                                           --38
							  ,cast(0 as decimal(12,2)) AS CHEQ_PROP                                          --39
							  ,cast(0 as decimal(12,2)) AS DEBITO                                             --40
							  ,cast(0 as decimal(12,2)) AS FINANC                                             --41
							  ,cast(0 as decimal(12,2)) AS OTROS                                              --42
							  ,cast(0 as decimal(12,2)) AS Total_Pagos                                        --43
							  ,cast(0 as decimal(12,2)) AS Dif                                                --44
							  ,i.Item as Item_Fac															  --45
							  ,cast(0 as decimal(12,5)) AS Coef_Pago										  --46 
							  ,F.Id_Cond_Pago AS Id_Cond_Pago										          --47 14/01/2020 Agregado Ticket 18.924
							  ,ISNULL(CCP.Descripcion, '''') AS Cond_Pago									  --48 14/01/2020 Agregado Ticket 18.924
							  ,F.IMP_PERCEP AS Imp_Total_Percep_Reten_Fac		  						      --49 14/01/2020 Agregado Ticket 18.924
							  ,0 AS Imp_Total_Percep_Reten_Rec										          --50 14/01/2020 Agregado Ticket 18.924
							  ,CLFC.Nombre_Fantasia		AS FC_CL_Nombre_Fantasia							  --51 27/01/2021
							  ,CLFC.Id_Cliente_Externo	AS FC_CL_Id_Cliente_Externo							  --52 27/01/2021
							  ,CLFC.Razon_Social		AS FC_CL_Razon_Social								  --53 27/01/2021
							  ,CLFC.Id_Tipo_Cli			AS FC_CL_Id_Tipo_Cli								  --54 27/01/2021
							  ,C.Id_Cobrador			AS CL_Id_Cobrador								      --55 04/02/2021
							  ,0						AS Id_Caja											  --56 04/02/2021
							  ,I.Bonif					AS Porc_Bonif_Item									  --57 13/04/2021 Agregado Ticket 22.253
							  ,((100 * I.Imp_Final) / (100-I.Bonif)) AS Imp_Final_Item_Sin_Desc				  --58 13/04/2021 Agregado Ticket 22.253
							  ,(((100 * I.Imp_Final) / (100-I.Bonif)) * (I.Bonif / 100)) AS Imp_Bonif_Item	  --59 13/04/2021 Agregado Ticket 22.253
							  '
  SET @SqlWhere = 'WHERE  f.id_cliente = c.id_Cliente
							AND ISNULL(F.Id_Cliente, 0) = CLFC.Id_Cliente
							AND f.id_estado_cbte in (1,2,4) 
							AND i.id_trans = f.id_trans 
							AND f.id_tipo_cbte = TF.id_tipo_cbte 
							AND I.Id_Producto = P.Id_Producto
							AND ISNULL(P.Id_Familia,0) = ISNULL(FP.Id_Familia,0)
							AND f.Fecha >= ''' + CONVERT(VARCHAR(8),@pFechaDesde   ,112) + '''
							AND f.Fecha <  ''' + CONVERT(VARCHAR(8),@pFechaHasta+1 ,112) + '''
							AND F.Imp_total <> 0
							AND ISNULL(F.Id_Cond_Pago, 0) = ISNULL(CCP.Id_Cond_Pago, 0)
							AND TF.Compromete_Factura in (1,-1)
							AND F.ID_COND_PAGO = 1 
							AND ISNULL(F.Id_Cobrador,'''') = ISNULL(V.Id_Vendedor,'''')
 							AND ISNULL(CT.ID_TIPO_CLI,0) = ISNULL([dbo].[SF_Cli_Categ_Mes](i.Id_cliente, isnull(i.Fecha_QA,F.Fecha)),0)
							AND i.Imp_Gravado <> 0 '

  
  IF @EXISTE_TAG > 0
  BEGIN
	  SET @SqlFrom = 'FROM cbtes_items i,cbtes f, Cbtes_Tipos TF, Clientes C,TagFilePos_ TAG, Productos P,Prod_Familias FP, Vendedores V, Clientes_Tipos CT, Clientes CLFC, Cbtes_Cond_Pago CCP'
      SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND (i.id_producto = TAG.POS 
							      AND TAG.TBL = ' + CAST(@pEquate  AS VARCHAR(10))  + '
								  AND TAG.USR = ' + CAST(@pUsuario AS VARCHAR(10)) + '
								 ) ' 
  END
  ELSE
  BEGIN
	  SET @SqlFrom = 'FROM cbtes_items i,cbtes f, Cbtes_Tipos TF, Clientes C, Productos P,Prod_Familias FP, Vendedores V, Clientes_Tipos CT, Clientes CLFC, Cbtes_Cond_Pago CCP'
  END


  SET @Sql = @SqlSelect + ' ' + @SqlInto +' '+ @SqlFrom + ' ' + @SqlWhere 
  --print @Sql
  EXEC('INSERT INTO #Reporte ' + @sql)

 --
  SELECT * FROM #Reporte

  DROP TABLE #Reporte

-- EXEC CP_Productos_Cobros -1,90,'20171201','20181231',2,0,0,'L'

-- EXEC CP_Productos_Cobros -1,90,'20200122','20200122',2,0,0,'-'

/*
EXEC dbo.CP_Productos_Cobros	-1			/*@pUsuario INT*/,
								90			/*@pEquate  SMALLINT*/,
							   '20201201'	/*@pFechaDesde DATETIME*/,
							   '20201201'	/*@pFechaHasta DATETIME*/,
							   2			/*@GenerarLiquidacion TINYINT*/,
							   0			/*@Id_Periodo_Caja INT*/,
							   0			/*@Detallar_FPago SMALLINT*/,
							   ''			/*@Tipo_Cob CHAR(1)*/

*/